/* Include file for Jeff Glatt's GENMIDI.DLL */
#ifndef _INC_GENMIDI
#define _INC_GENMIDI

#if !defined(_WIN32)
#error ERROR: Only Win32 target supported by GENMIDI.DLL!
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* GenMidi version */
#define GENMIDIVERSION 0

#if !defined(_GENMIDILIB_)
#define GENMIDIAPI __declspec(dllimport)
#else
#define GENMIDIAPI __declspec(dllexport)
#endif

/* Instrument Flags */
#define MIDI_ALLNOTESOFF	0x80 /* supports "All Notes Off" controller */
#define MIDI_ALLSOUNDSOFF	0x40 /* supports "All Sounds Off" controller */
#define MIDI_ALLCTLSOFF		0x20 /* supports "All Controllers Off" controller */
#define MIDI_COARSEFINE		0x10 /* supports both coarse (MSB) and fine (LSB) controllers */
#define MIDI_POLYRESET		0x08 /* needs Polyphonic Aftertouch to be reset */
#define MIDI_PRESSRESET		0x04 /* needs Channel Pressure to be reset */
#define MIDI_PITCHRESET		0x02 /* needs Pitch Wheel to be reset */

/* Program Flags */
#define MIDI_PGM_HAS_NOTES	0x80 /* Indicates that the Program has note names */
#define MIDI_DRUMKIT		0x40 /* Indicates that the Program is a GM Drum Kit For every Note number
                                 in this Program which doesn't have a specific Note name assigned to
								 it, the default GM Drum Key name is used for that number */
/* Bank Flags */
#define MIDI_GM_BANK		0x80 /* Indicates that the Bank is a GM Bank. For every Program number
                                 in this Bank which doesn't have a specific Program name assigned to
								 it, the default GM Program name is used for that number */

/* MIDINAMES structure (1 Global structure within DLL. DLL functions set it) */
typedef struct _MIDINAMES
{
  unsigned char * Instrument;	/* Instrument Name */
  unsigned char * Bank;			/* Bank Name */
  unsigned char * Pgm;			/* Program Name */
  unsigned char * Note;			/* Note Name */
} MIDINAMES;

GENMIDIAPI MIDINAMES MidiNames;
GENMIDIAPI unsigned char MidiGenVersion[2];

/* MidiLock Lock */
#define MIDILOCK_ACCESS		0
#define MIDILOCK_MODIFY		1
#define MIDILOCK_WAITFOREVER 0xFFFFFFFF

/* Accessing/Locking the database */
GENMIDIAPI unsigned long MidiLock(unsigned char Lock, unsigned long Wait);
GENMIDIAPI void MidiUnlock(void);

/* Error IDs */
#define MIDIERR_FIRST			247
#define MIDIERR_NOREAD			MIDIERR_FIRST
#define MIDIERR_WRONGFILE		MIDIERR_NOREAD+1
#define MIDIERR_ALLOC			MIDIERR_WRONGFILE+1
#define MIDIERR_CORRUPT			MIDIERR_ALLOC+1
#define MIDIERR_DLLFAIL			MIDIERR_CORRUPT+1
#define MIDIERR_INSCONFLICT		MIDIERR_DLLFAIL+1
#define MIDIERR_BANKCONFLICT	MIDIERR_INSCONFLICT+1
#define MIDIERR_PGMCONFLICT		MIDIERR_BANKCONFLICT+1
#define MIDIERR_NOTECONFLICT	MIDIERR_PGMCONFLICT+1
#define MIDIERR_NOWRITE			MIDIERR_NOTECONFLICT+1
#define MIDIERR_BADWRITE		MIDIERR_NOWRITE+1
#define MIDIERR_TIMEOUT			MIDIERR_BADWRITE+1
#define MIDIERR_NOINSNUM		MIDIERR_TIMEOUT+1
#define MIDIERR_NEEDNAME		MIDIERR_NOINSNUM+1

GENMIDIAPI unsigned long MidiGenError(unsigned char * Buffer, unsigned long BufferSize, unsigned long Error);

#define MIDIGET_INSTRUMENT	0
#define MIDIGET_BANK		1
#define MIDIGET_PGM			2
#define MIDIGET_NOTE		3
#define MIDIGET_VERSION		4

/* Accessing DLL variables (for C++ programs) */
GENMIDIAPI unsigned char * MidiGetField(unsigned long Get);

/* GM Program name to MIDI Program Change number, and vice versa */
GENMIDIAPI unsigned char * MidiIsGMPgm(unsigned char * PgmName, unsigned char * PgmNum, unsigned char Len);

/* GM Drum Key name to MIDI note number, and vice versa */
GENMIDIAPI unsigned char * MidiIsGMDrum(unsigned char * NoteName, unsigned char * NoteNum, unsigned char Len);

/* Note name to MIDI note number, and vice versa */
GENMIDIAPI unsigned char * MidiGetNoteName(unsigned char NoteNum, unsigned char * PgmName, char KeySig);
GENMIDIAPI unsigned char MidiGetNoteNum(unsigned char * NoteName, unsigned char * PgmName, unsigned char * DefOct);

/* Diatonic pitch name to MIDI note number, and vice versa */
GENMIDIAPI unsigned char MidiPitchToNum(unsigned char * NoteName, unsigned char * DefOct, unsigned char ** EndPtr);
GENMIDIAPI unsigned long MidiNumToPitch(unsigned char * Buffer, unsigned char NoteNum, char KeySig);

/* Program name to MIDI Program Change number, and vice versa */
GENMIDIAPI unsigned char * MidiGetPgmName(unsigned char PgmNum, unsigned short BankNum, unsigned char InstrumentNum);
GENMIDIAPI unsigned short MidiGetPgmNum(unsigned char * PgmName, unsigned short BankNum, unsigned char InstrumentNum);

/* Bank name to Bank number (MSB/LSB), and vice versa */
GENMIDIAPI unsigned char * MidiGetBankName(unsigned short BankNum, unsigned char InstrumentNum);
GENMIDIAPI unsigned long MidiGetBankNum(unsigned char * BankName, unsigned char InstrumentNum);
/* Bank number (MSB/LSB) to a signed short, and vice versa */
GENMIDIAPI signed short MidiBankToNum(unsigned short BankNum);
GENMIDIAPI unsigned short MidiNumToBank(signed short Value);

#define MIDIDUMMYBANKBIT	0x80

/* Generate dummy Bank number (MSB/LSB) */
GENMIDIAPI unsigned short MidiDummyBankNum(unsigned char * InstrumentName);

/* Instrument name to instrument number, and vice versa */
GENMIDIAPI unsigned short MidiGetInstrumentNum(unsigned char * InstrumentName);
GENMIDIAPI unsigned char * MidiGetInstrumentName(unsigned char InstrumentNum);

/* Searching through the database */
GENMIDIAPI unsigned short MidiNextInstrument(unsigned char ** InstrumentName);
GENMIDIAPI unsigned long MidiNextBank(unsigned char ** BankName, unsigned char * InstrumentName);
GENMIDIAPI unsigned short MidiNextPgm(unsigned char ** ProgramName, unsigned char * BankName, unsigned char ** PgmStruct);
GENMIDIAPI unsigned char MidiNextNote(unsigned char ** NoteName, unsigned char * PgmName, unsigned char ** NoteStruct);

/* Add/Modify instrument/bank/program/note */
GENMIDIAPI unsigned long MidiAddInstrument(unsigned char * InstrumentName, unsigned char *NewName, unsigned char InstrumentFlags);
GENMIDIAPI unsigned long MidiAddBank(unsigned char * InstrumentName, unsigned char * BankName, unsigned char *NewName, unsigned short BankNum, unsigned char BankFlags);
GENMIDIAPI unsigned long MidiAddPgm(unsigned char * InstrumentName, unsigned char * BankName, unsigned char *NewName, unsigned char PgmNum, unsigned char PgmFlags);
GENMIDIAPI unsigned long MidiAddNote(unsigned char * InstrumentName, unsigned char * BankName, unsigned char * PgmName, unsigned char *NewName, unsigned char NoteNum, unsigned char NoteFlags);

/* Delete instrument/bank/program/note */
GENMIDIAPI void MidiDelInstrument(unsigned char * InstrumentName);
GENMIDIAPI void MidiDelBank(unsigned char * InstrumentName, unsigned char * BankName);
GENMIDIAPI void MidiDelPgm(unsigned char * InstrumentName, unsigned char * BankName, unsigned char * PgmName);
GENMIDIAPI void MidiDelNote(unsigned char * InstrumentName, unsigned char * BankName, unsigned char * PgmName, unsigned char * NoteName);

/* MidiSaveDat Operation */
#define MIDISAVE_ALL		0
#define MIDISAVE_INSTRUMENT	1
#define MIDISAVE_BANK		2
#define MIDISAVE_PGM		3

/* MidiLoadDat Operation */
#define MIDILOAD_ALL		0
#define MIDILOAD_INSTRUMENT	1
#define MIDILOAD_BANK		2
#define MIDILOAD_PGM		3
#define MIDILOAD_OVERWRITE	0x80

/* Save/Load database */
GENMIDIAPI unsigned long MidiSaveDat(const char * Filename, unsigned char * ElementName, unsigned char Operation);
GENMIDIAPI unsigned long MidiLoadDat(const char * Filename, unsigned char * ElementName, unsigned char Operation);

/* Swap Operations */
#define MIDISWAP_INSTRUMENT	0
#define MIDISWAP_BANK		1
#define MIDISWAP_PGM		2
#define MIDISWAP_NOTE		3

/* Swap 2 elements */
GENMIDIAPI unsigned long MidiSwapDat(unsigned char * Name1, unsigned char * Name2, unsigned char Operation);

/* Controller name to MIDI Controller number, and vice versa */
GENMIDIAPI unsigned char MidiGetCtlNum(unsigned char * CtlName);
GENMIDIAPI unsigned char MidiGetCtlNum2(unsigned char * CtlArray, unsigned char * CtlName);
GENMIDIAPI unsigned char * MidiGetCtlStr2(unsigned char * CtlArray, unsigned char CtlNum);
GENMIDIAPI unsigned char * MidiGetCtlStr(unsigned char CtlNum);

/* Convert two MIDI bytes representing a 14-bit value into an unsigned short, and vice versa */
GENMIDIAPI unsigned short MidiDataToNum(unsigned char * MidiData);
GENMIDIAPI void MidiNumToData(unsigned short Value, unsigned char *MidiData);

#ifdef __cplusplus
}
#endif

#endif /* _INC_GENMIDI */